package coreservlets.filters;

/** Filtr zastpuje wszystkie wystpienia cigu znakw target
 *  cigiem zastpczym replacement. Cigi target oraz
 *  replacement s zdefiniowane jako parametry inicjalizacyjne
 *  filtra w pliku web.xml.
 *  <P>
 *  Taken from Core Servlets and JavaServer Pages Volume II
 *  from Prentice Hall and Sun Microsystems Press,
 *  http://volume2.coreservlets.com/.
 *  (C) 2007 Marty Hall, Larry Brown, and Yaakov Chaikin;
 *  may be freely used or adapted.
 */
public class ReplaceSiteNameFilter extends ModificationFilter {
	private boolean isCaseInsensitive = false;
	
  /** Cig znakw przeznaczony do zastpienia.
   */
  public String getTarget() {
  	return getInitParameter("target");
  }

  /** Cig znakw zastpujcy cig znakw target.
   */
  public String getReplacement() {
  	return getInitParameter("replacement");
  }
  
  /** Zwraca warto parametru inicjalizacyjnego wskazanego przez
   * 'param' lub warto null, jeli parametr nie wystpuje
   *  bd te jest pustym cigiem znakw.
   */
  private String getInitParameter(String param) {
  	String value = config.getInitParameter(param);
  	if ((value == null) || (value.trim().equals(""))) {
  		value = null;
  	}
  	
  	return value;
  }
  
  /** Wskazanie, czy w trakcie wyszukiwania cigu target
   *  ma by uwzgldniana wielko znakw.
   */
  public void setCaseInsensitive(boolean flag) {
    isCaseInsensitive = flag;
  }

  /** Zwraca warto true lub false wskazujc, czy
   *  w wyszukiwaniu cigu target uwzgldniana ma by
   *  wielko znakw.
   */
  public boolean isCaseInsensitive() {
    return(isCaseInsensitive);
  }

  /** Zastpuje wszystkie cigi odpowiadajce cigowi target
   *  cigiem zastpujcym replacement.
   */
  public String doModification(String orig) {
    if ((getTarget() == null) || (getReplacement() == null)) {
      return(orig);
    } else {
      String target = getTarget();
      if (isCaseInsensitive()) {
        target = "(?i)" + target;
      }
      String replacement = getReplacement();
      return(orig.replaceAll(target, replacement));
    }
  }
}
